<?php
// create_exam.php - Admin Create New Exam

require_once '../db.php';
require_admin();

// Set page title for header
$page_title = 'Create New Exam';

$error = '';
$exam_modes = ['Mixed', 'MCQ', 'Theory', 'Fill-in-the-gaps'];

// Fetch all grades that do NOT have an active exam
$sql_grades = "
    SELECT 
        G.grade_name AS grade
    FROM 
        grades G
    LEFT JOIN 
        exams E ON G.grade_name = E.target_grade AND E.is_active = 1
    WHERE 
        E.exam_id IS NULL
    ORDER BY 
        G.grade_name
";
$grades_result = execute_query($mysqli, $sql_grades);
$grades = $grades_result ? $grades_result->fetch_all(MYSQLI_ASSOC) : [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $target_grade = trim($_POST['target_grade'] ?? '');
    $exam_title = trim($_POST['exam_title'] ?? '');
    $exam_description = trim($_POST['exam_description'] ?? '');
    $duration_minutes = (int) ($_POST['duration_minutes'] ?? 0);
    $total_questions = (int) ($_POST['total_questions'] ?? 0);
    $exam_mode = $_POST['exam_mode'] ?? '';
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    $shuffle_questions = isset($_POST['shuffle_questions']) ? 1 : 0;
    $created_by = get_current_user_id();

    if (empty($exam_title) || empty($target_grade) || !in_array($exam_mode, $exam_modes) || $duration_minutes <= 0 || $total_questions <= 0) {
        $error = 'Please fill in all required fields correctly.';
    } else {
        // Check if shuffle_questions column exists, if not add it
        $sql_check_column = "SHOW COLUMNS FROM exams LIKE 'shuffle_questions'";
        $column_result = execute_query($mysqli, $sql_check_column);
        
        if ($column_result && $column_result->num_rows === 0) {
            // Add the column if it doesn't exist
            $sql_add_column = "ALTER TABLE exams ADD COLUMN shuffle_questions TINYINT(1) DEFAULT 0 AFTER is_active";
            $mysqli->query($sql_add_column);
        }

        $sql_insert = "INSERT INTO exams (target_grade, exam_title, exam_description, duration_minutes, total_questions, exam_mode, is_active, shuffle_questions, created_by) 
                       VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $insert_id = execute_insert($mysqli, $sql_insert, 'ssiiisiii', [
            $target_grade,
            $exam_title,
            $exam_description,
            $duration_minutes,
            $total_questions,
            $exam_mode,
            $is_active,
            $shuffle_questions,
            $created_by
        ]);

        if ($insert_id) {
            $_SESSION['success_message'] = "Exam '{$exam_title}' created successfully.";
            redirect('admin/exams.php');
        } else {
            $error = 'Error creating exam.';
        }
    }
}

include 'includes/header.php';

if ($error): ?>
    <p class="error"><?php echo $error; ?></p>
<?php endif; ?>

<form method="POST" action="create_exam.php">
    <div class="form-group">
        <label for="exam_title">Exam Title:</label>
        <input type="text" id="exam_title" name="exam_title"
            value="<?php echo htmlspecialchars($_POST['exam_title'] ?? ''); ?>" required>
    </div>
    <div class="form-group">
        <label for="target_grade">Target Grade:</label>
        <select id="target_grade" name="target_grade" required>
            <option value="">Select Grade</option>
            <?php foreach ($grades as $grade): ?>
                <option value="<?php echo $grade['grade']; ?>" <?php echo (($_POST['target_grade'] ?? '') === $grade['grade']) ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($grade['grade']); ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="form-group">
        <label for="exam_mode">Exam Mode:</label>
        <select id="exam_mode" name="exam_mode" required>
            <option value="">Select Mode</option>
            <?php foreach ($exam_modes as $mode): ?>
                <option value="<?php echo $mode; ?>" <?php echo (($_POST['exam_mode'] ?? '') === $mode) ? 'selected' : ''; ?>>
                    <?php echo $mode; ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="form-group">
        <label for="duration_minutes">Duration (minutes):</label>
        <input type="number" id="duration_minutes" name="duration_minutes" min="1"
            value="<?php echo htmlspecialchars($_POST['duration_minutes'] ?? 60); ?>" required>
    </div>
    <div class="form-group">
        <label for="total_questions">Total Questions:</label>
        <input type="number" id="total_questions" name="total_questions" min="1"
            value="<?php echo htmlspecialchars($_POST['total_questions'] ?? 10); ?>" required>
    </div>
    <div class="form-group">
        <label for="exam_description">Description:</label>
        <textarea id="exam_description"
            name="exam_description"><?php echo htmlspecialchars($_POST['exam_description'] ?? ''); ?></textarea>
    </div>
    <div class="form-group">
        <input type="checkbox" id="is_active" name="is_active" value="1" checked>
        <label for="is_active" style="display: inline;">Is Active</label>
    </div>
    <div class="form-group">
        <input type="checkbox" id="shuffle_questions" name="shuffle_questions" value="1">
        <label for="shuffle_questions" style="display: inline;">Shuffle Questions (Randomly pick questions equal to total questions count)</label>
    </div>
    <button type="submit">Create Exam</button>
</form>
<?php
include 'includes/footer.php';
?>