<?php
// admin/download_results.php - Admin Exam Results Download

require_once '../db.php';
require_admin();

// Set the CSV headers
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="exam_results_' . date('Ymd_His') . '.csv"');

// Open the output stream
$output = fopen('php://output', 'w');

// Write the CSV header row
fputcsv($output, ['Full Name', 'Staff ID', 'Grade', 'Exam Title', 'Score', 'Completion Time']);

// SQL Query to fetch all completed exam results
$sql = "
    SELECT 
        U.full_name,
        U.staff_id,
        U.grade,
        E.exam_title,
        SES.total_score,
        SES.end_time
    FROM 
        student_exam_sessions SES
    JOIN 
        users U ON SES.student_id = U.user_id
    JOIN 
        exams E ON SES.exam_id = E.exam_id
    WHERE 
        SES.is_submitted = 1
    ORDER BY 
        E.exam_title, U.full_name
";

$result = execute_query($mysqli, $sql);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        // Format the score for output
        $score = sprintf("%.2f", $row['total_score']);
        
        // Prepare the row data
        $rowData = [
            $row['full_name'],
            $row['staff_id'],
            $row['grade'],
            $row['exam_title'],
            $score,
            $row['end_time']
        ];
        
        // Write the row to the CSV file
        fputcsv($output, $rowData);
    }
} else {
    // Write a message if no results are found
    fputcsv($output, ['No completed exam results found.']);
}

// Close the output stream
fclose($output);

// Close the database connection
$mysqli->close();
exit;
?>
