<?php
// admin/includes/header.php - Reusable Admin Header and Navigation Menu

// Ensure this file is included after db.php and require_admin() is called
if (!defined('PROJECT_NAME')) {
    // Redirect or exit if not included properly
    exit("Access Denied: Header must be included after db.php and authentication.");
}

// Check for success/error messages in session
$success_message = $_SESSION['success_message'] ?? null;
$error_message = $_SESSION['error_message'] ?? null;
unset($_SESSION['success_message'], $_SESSION['error_message']);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'Admin Dashboard'; ?> - <?php echo PROJECT_NAME; ?></title>
    <link rel="stylesheet" href="<?php echo MAIN_CSS_PATH; ?>">
    <style>
        /* Admin Navigation Styling */
        .admin-nav {
            background-color: #1e3a8a; /* Dark Blue */
            padding: 10px 0;
            margin-bottom: 20px;
            border-radius: 6px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .admin-nav ul {
            list-style: none;
            padding: 0;
            margin: 0;
            display: flex;
            justify-content: flex-start;
            align-items: center;
        }
        .admin-nav ul li {
            margin: 0 15px;
        }
        .admin-nav ul li a {
            color: #ffffff;
            text-decoration: none;
            font-weight: 600;
            padding: 8px 12px;
            border-radius: 4px;
            transition: background-color 0.3s;
        }
        .admin-nav ul li a:hover,
        .admin-nav ul li a.active {
            background-color: #3b82f6; /* Primary Blue */
        }
        /* Dropdown Menu Styling */
        .admin-nav ul li.dropdown {
            position: relative;
        }
        .admin-nav ul li.dropdown .dropdown-menu {
            display: none;
            position: absolute;
            top: 100%;
            left: 0;
            background-color: #1e3a8a;
            min-width: 150px;
            z-index: 10;
            padding: 5px 0;
            border-radius: 0 0 6px 6px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }
        .admin-nav ul li.dropdown:hover .dropdown-menu {
            display: block;
        }
        .admin-nav ul li.dropdown .dropdown-menu li {
            margin: 0;
        }
        .admin-nav ul li.dropdown .dropdown-menu li a {
            padding: 8px 15px;
            display: block;
            white-space: nowrap;
            color: #ffffff;
        }
        .admin-nav ul li.dropdown .dropdown-menu li a:hover {
            background-color: #2563eb;
        }
        .admin-nav .logout-link {
            margin-left: auto;
            margin-right: 20px;
        }
        .admin-nav .logout-link a {
            background-color: #ef4444;
        }
        .admin-nav .logout-link a:hover {
            background-color: #dc2626;
        }
    </style>
</head>
<body>
    <div class="container admin-container">
        <header>
            <div class="admin-nav">
                <ul>
                    <li><a href="index.php" class="<?php echo (strpos($_SERVER['REQUEST_URI'], 'admin/index.php') !== false || strpos($_SERVER['REQUEST_URI'], 'admin/') === false) ? 'active' : ''; ?>">Dashboard</a></li>

	                    <li><a href="exams.php" class="<?php echo (strpos($_SERVER['REQUEST_URI'], 'exams.php') !== false) ? 'active' : ''; ?>">Exams</a></li>
	                    <li><a href="grades.php" class="<?php echo (strpos($_SERVER['REQUEST_URI'], 'grades.php') !== false || strpos($_SERVER['REQUEST_URI'], 'create_grade.php') !== false || strpos($_SERVER['REQUEST_URI'], 'edit_grade.php') !== false) ? 'active' : ''; ?>">Grades</a></li>
                    <li class="dropdown">
                        <a href="#" class="<?php echo (strpos($_SERVER['REQUEST_URI'], 'questions.php') !== false || strpos($_SERVER['REQUEST_URI'], 'bulk_upload_questions.php') !== false) ? 'active' : ''; ?>">Questions ▼</a>
                        <ul class="dropdown-menu">
                            <li><a href="questions.php">Manage Questions</a></li>
                            <li><a href="bulk_upload_questions.php">Bulk Upload Questions</a></li>
                        </ul>
                    </li>
                    <li class="dropdown">
                        <a href="#" class="<?php echo (strpos($_SERVER['REQUEST_URI'], 'create_user.php') !== false || strpos($_SERVER['REQUEST_URI'], 'bulk_upload.php') !== false || strpos($_SERVER['REQUEST_URI'], 'test_takers.php') !== false) ? 'active' : ''; ?>">Test-Takers ▼</a>
                        <ul class="dropdown-menu">
	                            <li><a href="test_takers.php">List & Status</a></li>
	                            <li><a href="manual_grading_list.php">Manual Grading</a></li>
                            <li><a href="create_user.php">Create Single</a></li>
                            <li><a href="bulk_upload.php">Bulk Upload</a></li>
                        </ul>
                    </li>
                    <li class="logout-link"><a href="<?php echo BASE_URL; ?>logout.php">Logout</a></li>
                </ul>
            </div>
            <h1><?php echo $page_title ?? 'Admin Dashboard'; ?></h1>
        </header>

        <?php if ($success_message): ?>
            <p class="success"><?php echo $success_message; ?></p>
        <?php endif; ?>
        <?php if ($error_message): ?>
            <p class="error"><?php echo $error_message; ?></p>
        <?php endif; ?>
