<?php
// forgot_password.php - Test-taker password request via Staff ID

require_once 'db.php';

$error = '';
$success = '';

// Function to generate a random alphanumeric password (copied from admin/create_user.php)
function generate_random_password($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $password = '';
    for ($i = 0; $i < $length; $i++) {
        $password .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $password;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');

    if (empty($username)) {
        $error = 'Please enter your Staff ID/Username.';
    } else {
        // 1. Find user by Username (which is now treated as Staff ID)
        $sql_user = "SELECT user_id, full_name, email FROM users WHERE username = ? AND user_type = 'Student'";
        $result_user = execute_query($mysqli, $sql_user, 's', [$username]);

        if ($result_user && $result_user->num_rows === 1) {
            $user = $result_user->fetch_assoc();
            $user_id = $user['user_id'];
            $email = $user['email'];
            $full_name = $user['full_name'];

            // 2. Generate new random password
            $raw_password = generate_random_password();
            $password_hash = password_hash($raw_password, PASSWORD_DEFAULT);

            // 3. Update user's password in the database
            $sql_update = "UPDATE users SET password_hash = ? WHERE user_id = ?";
            $updated = execute_non_query($mysqli, $sql_update, 'si', [$password_hash, $user_id]);

            if ($updated) {
                // 4. Simulate sending email with the new password
                // NOTE: In a real application, you would use a library like PHPMailer here.
                $email_subject = "Your Temporary Exam Portal Password";
                $email_body = "Dear $full_name,\n\nYour password has been reset as requested.\n\nYour temporary password is: $raw_password\n\nPlease log in immediately and change your password.\n\nRegards,\nAdmin Team";
                
                $email_subject = "Your Temporary Exam Portal Password";
                $email_body = "Dear $full_name,\n\nYour password has been reset as requested.\n\nYour temporary password is: $raw_password\n\nPlease log in immediately and change your password.\n\nRegards,\nAdmin Team";
                
                if (send_email($email, $email_subject, $email_body)) {
                    $success = "A temporary password has been sent to your registered email address ($email). Please check your inbox.";
                } else {
                    $success = "Password reset successful, but **failed to send email to $email**. Please contact support. (Temporary Password: $raw_password)";
                }
                
            } else {
                $error = 'Database error: Could not update password.';
            }

        } else {
            $error = 'Staff ID/Username not found or is not a student account.';
        }
    }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forgot Password - <?php echo PROJECT_NAME; ?></title>
    <link rel="stylesheet" href="<?php echo MAIN_CSS_PATH; ?>">
</head>
<body>
    <div class="container">
        <h1>Forgot Password</h1>
        <h2>Request Temporary Exam Password</h2>
        
        <?php if ($error): ?>
            <p class="error"><?php echo $error; ?></p>
        <?php endif; ?>
        <?php if ($success): ?>
            <p class="success"><?php echo $success; ?></p>
        <?php endif; ?>

        <form method="POST" action="forgot_password.php">
            <div class="form-group">
                <label for="username">Enter Staff ID/Username:</label>
                <input type="text" id="username" name="username" required>
            </div>
            <button type="submit">Request Password</button>
        </form>
        
        <p class="text-center mt-20"><a href="index.php">Back to Login</a></p>
    </div>
</body>
</html>
<?php $mysqli->close(); ?>
