<?php
// student/camera_test.php - Mandatory pre-exam camera test page

require_once '../db.php';
require_student();

$session_id = (int) ($_GET['session_id'] ?? 0);

if ($session_id === 0) {
    $_SESSION['error_message'] = "Invalid exam session ID provided.";
    redirect('student/start_exam.php');
}

// Check if the session is valid and belongs to the student
$student_id = get_current_user_id();
$sql_session = "SELECT session_id FROM student_exam_sessions WHERE session_id = ? AND student_id = ?";
$result_session = execute_query($mysqli, $sql_session, 'ii', [$session_id, $student_id]);

if (!$result_session || $result_session->num_rows === 0) {
    $_SESSION['error_message'] = "Invalid or unauthorized exam session.";
    redirect('student/start_exam.php');
}

// Define the URL for the next step
$take_exam_url = BASE_URL . 'student/take_exam.php?session_id=' . $session_id;

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Webcam Test - <?php echo PROJECT_NAME; ?></title>
    <link rel="stylesheet" href="<?php echo MAIN_CSS_PATH; ?>">
    <style>
        .camera-test-container {
            max-width: 600px;
            margin: 50px auto;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 8px;
            text-align: center;
        }
        #webcam-feed {
            width: 100%;
            max-height: 450px;
            background-color: #eee;
            border: 1px solid #333;
            margin-bottom: 20px;
            display: block;
        }
        .status-message {
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 4px;
        }
        .status-success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .status-error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
    </style>
</head>
<body>
    <div class="container camera-test-container">
        <h2>Webcam Check for Proctoring</h2>
        <p>Please allow access to your webcam to proceed with the exam. Ensure your face is clearly visible in the preview.</p>
        
        <video id="webcam-feed" autoplay muted></video>
        
        <div id="status-area" class="status-message status-error">
            Checking for webcam access...
        </div>
        
        <button id="start-exam-btn" disabled>Start Exam</button>
        
        <p><small>If you cannot see your video, please check your browser permissions and ensure no other application is using your camera.</small></p>
    </div>

    <script>
        const videoElement = document.getElementById('webcam-feed');
        const statusArea = document.getElementById('status-area');
        const startButton = document.getElementById('start-exam-btn');
        const takeExamUrl = '<?php echo $take_exam_url; ?>';
        let stream = null;

        function updateStatus(message, isError = false) {
            statusArea.textContent = message;
            statusArea.className = 'status-message ' + (isError ? 'status-error' : 'status-success');
            startButton.disabled = isError;
            // Explicitly set the button state based on success/error
            if (!isError) {
                startButton.disabled = false;
            } else {
                startButton.disabled = true;
            }
        }

        async function startCameraTest() {
            if (!navigator.mediaDevices || !navigator.mediaDevices.getUserMedia) {
                updateStatus('Webcam not supported in this browser.', true);
                return;
            }

            try {
                // Request video stream
                stream = await navigator.mediaDevices.getUserMedia({ video: true, audio: false });
                
                // Display the stream
                videoElement.srcObject = stream;
                videoElement.play();
                
                updateStatus('Webcam check successful! You can now start the exam.', false);
                startButton.disabled = false; // Ensure button is enabled on success
                
                // Add click listener to the button
                startButton.addEventListener('click', () => {
                    // Stop the stream to release the camera before redirecting
                    if (stream) {
                        stream.getTracks().forEach(track => track.stop());
                    }
                    window.location.href = takeExamUrl;
                });

            } catch (err) {
                console.error('Error accessing webcam:', err);
                let errorMessage = 'Could not access webcam. Please ensure you have a webcam and have granted permission.';
                if (err.name === 'NotAllowedError') {
                    errorMessage = 'Camera access denied. Please allow camera access in your browser settings.';
                } else if (err.name === 'NotFoundError') {
                    errorMessage = 'No camera found. Please connect a webcam.';
                }
                updateStatus(errorMessage, true);
                startButton.disabled = true; // Ensure button is disabled on failure
            }
        }

        // Start the test when the page loads
        window.onload = startCameraTest;
    </script>
</body>
</html>
<?php $mysqli->close(); ?>
